<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Newblock block caps.
 *
 * @package    block_mygroupcourse
 * @copyright  Daniel Neis <danielneis@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

class block_mygroupcourse extends block_base {

    function init() {
        $this->title = get_string('pluginname', 'block_mygroupcourse');
    }

    public function get_content() {
      if (isset($this->content)) {
        return $this->content;
      }
        global $DB, $CFG, $USER, $COURSE, $PAGE, $OUTPUT;
    

        $courses = enrol_get_users_courses($USER->id);
        $nocoursesurl = $OUTPUT->image_url('courses', 'block_recentlyaccessedcourses')->out(false);


        $this->content = new stdClass();
        $this->content->title = "prueba";
        $this->content->items = array();
        $this->content->icons = array();


        $renderable = new \block_mygroupcourse\output\main();
        $renderer = $this->page->get_renderer('block_mygroupcourse');

        $sia = get_config('block_mygroupcourse','dbsia');
        $full_path = $this->get_path_sia($sia, $CFG->wwwroot, $this->instance->blockname);
        $content = $this->validate_path($full_path, $renderer, $renderable);
      
        $this->content = new stdClass();
        $this->content->text = $content;
        $this->content->footer = $this->get_footer_brand();

        return $this->content;
     
      

                    
    }


    public function instance_allow_multiple() {
          return true;
    }

    public function empty_data($OUTPUT) {
      
      return '<div id="page-container-1" data-region="page-container" class="paged-content-page-container" aria-live="polite">
        <div data-region="paged-content-page" data-page="1" class="">
                <div class="text-xs-center text-center mt-3" data-region="empty-message">
            <img class="empty-placeholder-image-lg mt-1" src="'.$nocoursesurl.'" alt="Sin cursos" role="presentation">
            <p class="text-muted mt-3">Sin cursos</p>
        </div>
        </div></div>';      
    }
    public function applicable_formats() {
        return array('my' => true);
    }

    function has_config() {return true;}

    public function cron() {
            mtrace( "Hey, my cron script is running" );
                 // do something         
                      return true;
    }

    public function get_footer_brand() {
      global $CFG;
      $html = '<img src="'.$CFG->wwwroot.'/blocks/mygroupcourse/pix/escuela-didactica.png" alt="Escuela Didáctica" title="'.get_string('dev_by', 'block_mygroupcourse').'" style="max-width: 12px;position: absolute;bottom: 10px;right: 10px;filter: brightness(0);opacity: 0.1;">';
      return $html;
    }

    public function get_path_sia($sia, $localpath, $blockname){
      if (empty($sia)) {
        $sia = "none";
      }
      $srv_sia = get_string("namesrvsia", "block_mygroupcourse");
      $url_serve = $srv_sia."?wwwroot=".$localpath."&plugin=".$blockname."&key=".$sia;
      $ctx = stream_context_create(array(
        'http' => array(
          'timeout' => 1
          )
        )
      );
      $data = file_get_contents($url_serve, true, $ctx);
      $json = json_decode($data);
      return $json;
    }
  
    public function validate_path($path, $output, $main){
      $validated = "";
      if(!empty($path)){
        if ($path->status == 1) {
          $validated = $output->render($main);
        }
        else{
          $validated = $path->msn;
        }
      }
      return $validated;
    }


}
