



define(['jquery',
'core/config',
'core/templates' ,
'core/notification',
],
function(
$,
mdlcfg,
Templates,
Notification
) {


template_cards = 'block_mygroupcourse/cards';
current_category='';

$('.click-category-mygroupcourse').on('click',function(){
if(current_category==$(this).attr('data-id')){
   return;
}
current_category=$(this).attr('data-id')
$.ajax({
    type: "POST",
    url:  mdlcfg.wwwroot+"/blocks/mygroupcourse/api.php",
    data: 'task=get_courses&id_category='+$(this).attr('data-id'),
    dataType: "json",
    beforeSend: function(){
        $('.loader-group-courses').removeClass('hidden').addClass('overlay-icon-container');
        return Templates.replaceNodeContents($('.gropucourses-container'), '','');
    },
    success: function(res) {
        $('.loader-group-courses').removeClass('overlay-icon-container').addClass('hidden');
       try{
        if(res.courses){
             let have_courses = false;
             let have_nocurse_img =false;
            if(res.courses.length>0){
                have_courses=true;
            }
            if(res.nocoursesurl){
                have_nocurse_img=true
            }
           html= Templates.render(template_cards, {                                   
                                    have_courses: have_courses, 
                                    courses:res.courses,
                                    nocoursesurl:res.nocoursesurl,
                                    have_nocurse_img:have_nocurse_img
            }).then(function(html, js) {                 
                
                return Templates.replaceNodeContents($('.gropucourses-container'), html, js);
            }).catch(Notification.exception);
    
        }
       }catch(e){

       }
    },
    error: function(){
        $('.loader-group-courses').removeClass('overlay-icon-container').addClass('hidden');
    }
 });
})

var init = function(root) {
    root = $(root);

};


return {
    init: init
  
};

});