<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package     mod_agilesson
 * @copyright   2019 Jose Gomez <info@escueladidactica.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


/*
* Este documento es el encargado de setear pagina e invocar mustache
* para ver todos los resultados del plugin
*/

require_once(__DIR__ . '/../../config.php');
require_once('locallib.php');
 
$id = required_param('id', PARAM_INT);
list ($course, $cm) = get_course_and_cm_from_cmid($id, 'agilesson');
require_course_login($course, true, $cm);//Esta linea le da continuidad a la miga de pan

require_login(null, false);
if (isguestuser()) {
    throw new require_login_exception('Guests are not allowed here.');
}
$context = context_module::instance($cm->id);

$title = get_string('pluginname', 'agilesson');
$pageurl = new moodle_url('/mod/agilesson/view.php');
$pageurl->params(array('course' => $course->id, 'instanceid' => $cm->instance));
//$PAGE->set_context($context);
if ($course->id == SITEID) {
    $PAGE->set_pagelayout('incourse');
}

$PAGE->set_url($pageurl);
$PAGE->set_title($title);
$PAGE->set_heading($course->fullname);
$PAGE->requires->jquery();

$output = $PAGE->get_renderer('mod_agilesson');
echo $output->header();

$view = new \mod_agilesson\output\agileview($cm->instance);
echo $output->render($view);

echo $output->footer();
