<?php

if (!defined('MOODLE_INTERNAL')) {
    die('Direct access to this script is forbidden.');    ///  It must be included from a Moodle page
}

define('CANTIDAD_HIDDEN', 50); //en el archivo agilesson_form.js hay una constante LIMIT que tambien se debe cambiar si se cambia esta constante.

require_once($CFG->dirroot.'/course/moodleform_mod.php');
require_once($CFG->dirroot.'/mod/agilesson/locallib.php');
 
class mod_agilesson_mod_form extends moodleform_mod {
 
    function definition() {
        global $CFG, $DB, $OUTPUT, $PAGE;

		$mform =& $this->_form;

		$activities = array();
		$contents = array();
		$resources = array();
		$others_contents = array();
		$others_activities = array();
		$others_activities_array = array();
		$others_contents_array = array();

		if(!empty($this->_cm)){
			$agilesson = $DB->get_record('agilesson', ['id'=>$this->_cm->instance]);
			$presentation = $DB->get_record('agilesson_presentation', ['id_agilesson'=>$this->_cm->instance]);
			$contents = $DB->get_records('agilesson_content', ['id_agilesson'=>$this->_cm->instance]);
			$activities = $DB->get_records('agilesson_activity', ['id_agilesson'=>$this->_cm->instance]);
			$resources = $DB->get_records('agilesson_modules', ['id_agilesson'=>$this->_cm->instance]);
			
			$others_contents = $DB->get_records_sql('SELECT * from '.$CFG->prefix.'agilesson_content where id_agilesson in (SELECT id from '.$CFG->prefix.'agilesson where id <> '.$this->_cm->instance.' and course = '.$agilesson->course.')');

			foreach($others_contents as $oc){
				$others_contents_array["$oc->content_name;$oc->content_url;$oc->content_openin"]= $oc->content_name;
			}

			$others_activities = $DB->get_records_sql('SELECT * from '.$CFG->prefix.'agilesson_activity where id_agilesson in (SELECT id from '.$CFG->prefix.'agilesson where id <> '.$this->_cm->instance.' and course = '.$agilesson->course.')');

			foreach($others_activities as $oa){
				$others_activities_array["$oa->activity_name;$oa->activity_url;$oa->activity_openin"]= $oa->activity_name;
			}
		}

 		//-----------------------------------------------------------------------
        $mform->addElement('text', 'name', get_string('name', 'agilesson'), array('size'=>'48'));
        $mform->setType('name', PARAM_TEXT);
		$mform->addRule('name', null, 'required', null, 'client');
		$mform->addRule('name', get_string('maximumchars', '', 255), 'maxlength', 255, 'client');

		$mform->addElement('checkbox', 'titlestatus', get_string('titlestatus', 'agilesson'));
		$mform->setDefault('titlestatus', 1);

		$mform->addElement('text', 'presentation_url', get_string('header_presentation', 'agilesson'), array('id'=>'presentations_url', 'size'=>'48'));
		$mform->setType('presentation_url', PARAM_TEXT);
		$mform->addElement('html', '<div id="errors_presentation" class="alert alert-danger hidden"></div>');
		//$mform->addRule('presentation_url', null, 'required', null, 'client');
		$mform->addRule('presentation_url', get_string('maximumchars', '', 255), 'maxlength', 255, 'client');
		if (!empty($this->_cm) && $presentation) {
			$mform->setDefault('presentation_url', $presentation->presentation_url);
		}

		//$this->standard_intro_elements(get_string('description', 'agilesson'));

        $mform->addElement('textarea', 'description', get_string('description', 'agilesson'), 'wrap="virtual" rows="10" cols="48"');
		$mform->setType('description', PARAM_TEXT);
		if (property_exists($this->current, 'description')) {
			$mform->setDefault('description', $this->current->description);
		}

		$mform->addElement('checkbox', 'sequentially', get_string('sequentially', 'agilesson'));
		$mform->setDefault('sequentially', 1);
 	
 		/**
				* SELECT PARA CONSULTAR LOS MODULOS DISPONIBLES Y QUE NO ESTAN EN LAS LECCIONES DISPONIBLES YA REGISTRADAS
				*/
			$sql = 'SELECT a.id, b.name FROM '.$CFG->prefix.'course_modules a 
			INNER JOIN '.$CFG->prefix.'modules b ON a.module = b.id 
			WHERE a.course = '.$this->_course->id.' AND b.name != \'agilesson\' AND b.name != \'label\' AND a.deletioninprogress =0  AND
			a.id NOT in(
				SELECT am.module from '.$CFG->prefix.'agilesson_modules am 
				INNER JOIN '.$CFG->prefix.'course_modules aa ON am.id_agilesson =aa.instance AND aa.course='.$this->_course->id.'
				INNER JOIN '.$CFG->prefix.'modules bb ON aa.module = bb.id 
				WHERE 
				aa.course = '.$this->_course->id.' AND (bb.name = \'agilesson\' OR bb.name = \'label\') AND aa.deletioninprogress =0 
				)';
		


			$modules = $DB->get_records_sql($sql);

		 $data_resources = [];
			$data_resources[0] = get_string('select_module', 'agilesson');
		foreach($modules as $mod)
		{
		$dat2 =get_coursemodule_from_id(null, $mod->id, $this->_course->id, false, MUST_EXIST);			
		$instances = get_fast_modinfo($this->_course->id)->get_instances_of($dat2->modname);
		
		foreach($instances as $i)
		{
			$namemod = (s($i->get_module_type_name(false)));
		}

		$data_resources[$mod->id]= $namemod.": ".$dat2->name;

		}
		 
		$mform->addElement('header', 'resources', get_string('header_resources', 'agilesson'));
		$mform->addElement('select', 'contents_extra', "Recursos Disponibles", $data_resources); 
		$mform->setType('description', PARAM_TEXT);
		$radios_openin = array(
			$mform->createElement('radio', 'resources_openin', '', get_string('Backdrop', 'agilesson'), 0),
			$mform->createElement('radio', 'resources_openin', '', get_string('Self', 'agilesson'), 1),
			$mform->createElement('radio', 'resources_openin', '', get_string('Blank', 'agilesson'), 2),
		);
		$mform->addGroup($radios_openin, 'group_openin_resources', '', array('id'=>'resources_openin'), false);
		$mform->addElement('button', '', 'Agregar', array('id'=>'resources_btn'));
		 $mform->addElement('html', '<table id="content_resources_add_more" class="table table-striped '.(count($resources)>=1?'':'hidden').'"><tr><th>Recurso</th><th>Nombre</th><th>Mostrar</th><th></th></tr>');

		 if(count($resources)>=1)
		{
			foreach($resources as $resource){

				$dat2 =get_coursemodule_from_id(null, $resource->module, $this->_course->id, false, MUST_EXIST);			
				$instances = get_fast_modinfo($this->_course->id)->get_instances_of($dat2->modname);
				
				foreach($instances as $i)
				{
					$namemod = (s($i->get_module_type_name(false)));
				}

				$openin_txt="";
				switch($resource->content_openin){
					case 0:
						$openin_txt = get_string('Backdrop', 'agilesson');
						break;
					case 1:
						$openin_txt = get_string('Self', 'agilesson');
						break;
					case 2:
						$openin_txt = get_string('Blank', 'agilesson');
						break;
				}

				
				$mform->addElement('html', '<tr>
				<td>'.$namemod.'<input type="hidden" name="agi_resource[]" data-id-module="'.$resource->module.'" id="agi_resource" value="'.$resource->module.'_'.$resource->content_openin.'"> </td>
				<td>'.$dat2->name.'</td>
				<td>'.$openin_txt.'</td>
				<td><button type="button" class="delete_resource">Eliminar</button></td></tr>');
			}
		}
		$mform->addElement('html','</table>'); 

		//-----------------------------------------------------------------------
		 // $mform->addElement('header', 'contents', get_string('header_contents', 'agilesson'));
/* 		 if(count($others_contents_array)>=1){
			$mform->addElement('select', 'contents_extra', "Contenidos disponibles en otras lecciones", $others_contents_array); 
			$mform->addElement('button', '', 'Agregar Contenido Predeterminado', array('id'=>'contents_btn_predeterminado'));
		 } */

		/*  $mform->setType('colors', PARAM_TEXT);
		 $mform->addElement('text', 'contenidos_name', get_string('txt_name', 'agilesson'), array('id'=>'contents_name', 'size'=>'48'));
		 $mform->setType('contenidos_name', PARAM_TEXT);
		 $mform->addElement('text', 'contenidos_url', get_string('txt_url', 'agilesson'), array('id'=>'contents_url', 'size'=>'48'));
		 $mform->setType('contenidos_url', PARAM_TEXT);

 		$radios_openin = array(
 			$mform->createElement('radio', 'contents_openin', '',get_string('Backdrop', 'agilesson'), 0),
 			$mform->createElement('radio', 'contents_openin', '',get_string('Self', 'agilesson'), 1),
 			$mform->createElement('radio', 'contents_openin', '',get_string('Blank', 'agilesson'), 2),
 		);
 		$mform->addGroup($radios_openin, 'group_openin_contents', '', array('id'=>'contents_openin'), false);
 		$mform->addElement('html', '<div id="errors_content" class="alert alert-danger hidden"></div>');
 		$mform->addElement('button', '', 'Agregar', array('id'=>'contents_btn_add_more'));
		$mform->addElement('html', '<table id="content_container_add_more" class="table table-striped '.(count($contents)>=1?'':'hidden').'"><tr><th>'.get_string('txt_name', 'agilesson').'</th><th>'.get_string('txt_url', 'agilesson').'</th><th></th></tr>');

		if(count($contents)>=1)
		{
			$i=1;
			foreach($contents as $content){
				$mform->addElement('html', '<tr id="content_table_item_'.$i.'"><td>'.$content->content_name.'</td><td>'.$content->content_url.'</td><td><button type="button" class="delete_content" id="content_table_button_'.$i.'" data-indice="'.$i.'">Eliminar</button></td></tr>');
				$i++;
			}
		}
		 
		$mform->addElement('html','</table>'); */

 		//-----------------------------------------------------------------------
		 /* $mform->addElement('header', 'activities', get_string('header_activities', 'agilesson')); */
		 
/* 		 if(count($others_activities_array)>=1){
		 $mform->addElement('select', 'activities_extra', "Actividades disponibles en otras lecciones", $others_activities_array);
		 $mform->addElement('button', '', 'Agregar Actividad Predeterminada', array('id'=>'activities_btn_predeterminado'));
		 } */
		 
		 /* $mform->addElement('text', 'actividades_name', get_string('txt_name', 'agilesson'), array('id'=>'activities_name', 'size'=>'48'));
		 $mform->setType('actividades_name', PARAM_TEXT);
		 $mform->addElement('text', 'actividades_url', get_string('txt_url', 'agilesson'), array('id'=>'activities_url', 'size'=>'48'));
		 $mform->setType('actividades_url', PARAM_TEXT);

 		$radios_openin = array(
 			$mform->createElement('radio', 'activities_openin', '',get_string('Backdrop', 'agilesson'), 0),
 			$mform->createElement('radio', 'activities_openin', '',get_string('Self', 'agilesson'), 1),
 			$mform->createElement('radio', 'activities_openin', '',get_string('Blank', 'agilesson'), 2),
 		);
 		$mform->addGroup($radios_openin, 'group_openin_activities', '', array('id'=>'activities_openin'), false);
 		$mform->addElement('html', '<div id="errors_activity" class="alert alert-danger hidden"></div>');
 		$mform->addElement('button', '', 'Agregar', array('id'=>'activities_btn_add_more'));
		$mform->addElement('html', '<table id="activity_container_add_more" class="table table-striped '.(count($activities)>=1?'':'hidden').'"><tr><th>'.get_string('txt_name', 'agilesson').'</th><th>'.get_string('txt_url', 'agilesson').'</th><th></th></tr>');

		if(count($activities)>=1)
		{
			$i=1;
			foreach($activities as $activity){
				$mform->addElement('html', '<tr id="activity_table_item_'.$i.'"><td>'.$activity->activity_name.'</td><td>'.$activity->activity_url.'</td><td><button type="button" class="delete_activity" id="activity_table_button_'.$i.'" data-indice="'.$i.'">Eliminar</button></td></tr>');
				$i++;
			}
		}
		 
		$mform->addElement('html','</table>');

 */
 		//-------------------------------------------------------------------------
 		/* $types_input = array("activity", "content");

 		foreach ($types_input as $key => $type) {
			 switch($type){
				 case "content":
					$cantidad = count($contents);
					if($cantidad >=1){
						$i=1;
						foreach($contents as $content){
							$mform->addElement('hidden', $type.'_name_hidden_'.$i, $content->content_name);
							$mform->setType($type.'_name_hidden_'.$i, PARAM_TEXT);
							$mform->addElement('hidden', $type.'_url_hidden_'.$i, $content->content_url);
							$mform->setType($type.'_url_hidden_'.$i, PARAM_TEXT);
							$mform->addElement('hidden', $type.'_openin_hidden_'.$i, $content->content_openin);	
							$mform->setType($type.'_openin_hidden_'.$i, PARAM_TEXT);
							$i++;
						}
						for ($i; $i <= CANTIDAD_HIDDEN; $i++) { 
							$mform->addElement('hidden', $type.'_name_hidden_'.$i);
							$mform->setType($type.'_name_hidden_'.$i, PARAM_TEXT);
							$mform->addElement('hidden', $type.'_url_hidden_'.$i);
							$mform->setType($type.'_url_hidden_'.$i, PARAM_TEXT);
							$mform->addElement('hidden', $type.'_openin_hidden_'.$i);	
							$mform->setType($type.'_openin_hidden_'.$i, PARAM_TEXT);
						 }
					}
					else{
						for ($i=1; $i <= CANTIDAD_HIDDEN; $i++) { 
							$mform->addElement('hidden', $type.'_name_hidden_'.$i);
							$mform->setType($type.'_name_hidden_'.$i, PARAM_TEXT);
							$mform->addElement('hidden', $type.'_url_hidden_'.$i);
							$mform->setType($type.'_url_hidden_'.$i, PARAM_TEXT);
							$mform->addElement('hidden', $type.'_openin_hidden_'.$i);	
							$mform->setType($type.'_openin_hidden_'.$i, PARAM_TEXT);
						 }
					}
				 break;
				 case "activity":
					$cantidad = count($activities);
					if($cantidad >=1){
						$i=1;
						foreach($activities as $activity){
							$mform->addElement('hidden', $type.'_name_hidden_'.$i, $activity->activity_name);
							$mform->setType($type.'_name_hidden_'.$i, PARAM_TEXT);
							$mform->addElement('hidden', $type.'_url_hidden_'.$i, $activity->activity_url);
							$mform->setType($type.'_url_hidden_'.$i, PARAM_TEXT);
							$mform->addElement('hidden', $type.'_openin_hidden_'.$i, $activity->activity_openin);	
							$mform->setType($type.'_openin_hidden_'.$i, PARAM_TEXT);
							$i++;
						}
						for ($i; $i <= CANTIDAD_HIDDEN; $i++) { 
							$mform->addElement('hidden', $type.'_name_hidden_'.$i);
							$mform->setType($type.'_name_hidden_'.$i, PARAM_TEXT);
							$mform->addElement('hidden', $type.'_url_hidden_'.$i);
							$mform->setType($type.'_url_hidden_'.$i, PARAM_TEXT);
							$mform->addElement('hidden', $type.'_openin_hidden_'.$i);	
							$mform->setType($type.'_openin_hidden_'.$i, PARAM_TEXT);
						}						
				 	}
					else
					{
						for ($i=1; $i <= CANTIDAD_HIDDEN; $i++) { 
							$mform->addElement('hidden', $type.'_name_hidden_'.$i);
							$mform->setType($type.'_name_hidden_'.$i, PARAM_TEXT);
							$mform->addElement('hidden', $type.'_url_hidden_'.$i);
							$mform->setType($type.'_url_hidden_'.$i, PARAM_TEXT);
							$mform->addElement('hidden', $type.'_openin_hidden_'.$i);	
							$mform->setType($type.'_openin_hidden_'.$i, PARAM_TEXT);
						}
					}
				 break;
			 }
 		} */


 		//-----JAVASCRIPT ---------------------------------------------------------
 		$PAGE->requires->jquery();
        $PAGE->requires->js('/mod/agilesson/agilesson_form.js', true);
 
        $this->standard_coursemodule_elements();
        $this->add_action_buttons(true, false, null);
    }

    function validation($data, $files){
    	$errors = parent::validation($data, $files);

    	return $errors;
    }
}