<?php

defined('MOODLE_INTERNAL') || die;

require_once("$CFG->libdir/filelib.php");
require_once("$CFG->libdir/resourcelib.php");
require_once("$CFG->dirroot/mod/agilesson/lib.php");

class sia_agilesson {          
    public function get_path_sia($plugin){
        global $CFG;
		$srv_sia = get_string("namesrvsia", "agilesson");
		$url_serve = $srv_sia."?wwwroot=".$CFG->wwwroot."&plugin=".$plugin;
        /*$ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url_serve);
        curl_setopt($ch, CURLOPT_VERBOSE, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        $data = curl_exec($ch); 
        $info = curl_getinfo($ch);
        var_dump($info);
        curl_close($ch);*/
        $ctx = stream_context_create(array(
			'http' => array(
				'timeout' => 1
				)
			)
		);
		$data = file_get_contents($url_serve, true, $ctx);
        $json = json_decode($data);
		return $json;
	}
}

function order_agilesson_data($element, $id = false){

    if(!isset($element->titlestatus)){
        $titlestatus = 0;
    }
    else{
        $titlestatus = 1;
    }

    if(!isset($element->sequentially)){
        $sequentially = 0;
    }
    else{
        $sequentially = 1;
    }

    if($id){//Esto se hace cuando se actualiza
        $array = [
            "id" => $id,
            "name"=>$element->name,
            "titlestatus"=>$titlestatus, 
            "description"=>$element->description,
            "sequentially"=>$sequentially, 
            "status"=>$element->visible, 
            "course"=>$element->course, 
            "timecreated"=>strtotime(date("Y-m-d")), 
            "timemodified"=>strtotime(date("Y-m-d")), 
        ];
    }
    else{
        $array = [
            "name"=>$element->name, 
            "titlestatus"=>$titlestatus,
            "description"=>$element->description, 
            "sequentially"=>$sequentially,
            "status"=>$element->visible, 
            "course"=>$element->course, 
            "timecreated"=>strtotime(date("Y-m-d")), 
            "timemodified"=>strtotime(date("Y-m-d")), 
        ];
    }
    
	return $array;
}

function order_modules_data($element, $id, $update = false){
    global $DB;
    $modules = $_POST['agi_resource'];

    if($update){
        $DB->delete_records('agilesson_modules', ["id_agilesson"=>$id]);
    }

    if(count($modules)>=1){
        foreach($modules as $key => $value){
            $dato = explode("_", $value);
            $array[] = [
                "id_agilesson"=>$id,
                "module"=>$dato[0], 
                "content_openin"=>$dato[1], 
            ]; 
          }
    }
    
    return $array;
}
function order_presentation_data($element, $id, $update = false){

    if($update){
        $array = [
            "id"=>$update->id,
            "id_agilesson"=>$id,
            "presentation_url"=>validate_url($element->presentation_url), 
        ];
        return $array;
    }
    else{
        $array = [
            "id_agilesson"=>$id,
            "presentation_url"=>validate_url($element->presentation_url), 
        ];
        return $array;
    }

}

function order_content_data($element, $id, $update = false, $valida = false){
    global $DB;

    $objeto = new stdClass();
    foreach ($element as $key => $value) {
        if($value != ""){
            $dato = explode("_hidden_", $key);
            switch ($dato[0]) {
                case 'content_name':
                    $objeto->content_name[] = $value;
                    break;
                case 'content_url':
                    $objeto->content_url[] = validate_url($value);
                    break;
                case 'content_openin':
                    $objeto->content_openin[] = $value;
                    break;
            }
        }
    }

    $array = [];
    if ($valida) {
        if (isset($update)) {
            foreach ($update as $key => $value) {
                $DB->delete_records('agilesson_content', ["id"=>$value->id]);
            }
            for ($i=0; $i < count($objeto->content_name); $i++) {
                if(isset($objeto->content_name[$i])){
                    $tmp_array = [
                        "id_agilesson"=>$id,
                        "content_name"=>$objeto->content_name[$i], 
                        "content_url"=>$objeto->content_url[$i], 
                        "content_openin"=>$objeto->content_openin[$i],
                    ];
                    array_push($array, $tmp_array);
                }
            }
        }
        else{
            for ($i=0; $i < count($objeto->content_name); $i++) {
                if(isset($objeto->content_name[$i])){
                    $tmp_array = [
                        "id_agilesson"=>$id,
                        "content_name"=>$objeto->content_name[$i], 
                        "content_url"=>$objeto->content_url[$i], 
                        "content_openin"=>$objeto->content_openin[$i],
                    ];
                    array_push($array, $tmp_array);
                }
            }
        }
    }
    else{
        if (isset($objeto->content_name)) {
            for ($i=0; $i < count($objeto->content_name); $i++) {
                $tmp_array = [
                    "id_agilesson"=>$id,
                    "content_name"=>$objeto->content_name[$i], 
                    "content_url"=>$objeto->content_url[$i], 
                    "content_openin"=>$objeto->content_openin[$i],
                ];
                array_push($array, $tmp_array);
            }
        }
    }
    return $array;
}

function order_activity_data($element, $id, $update = false, $valida = false){
    global $DB;
    $objeto = new stdClass();
    foreach ($element as $key => $value) {
        if($value != ""){
            $dato = explode("_hidden_", $key);
            switch ($dato[0]) {
                case 'activity_name':
                    $objeto->activity_name[] = $value;
                    break;
                case 'activity_url':
                    $objeto->activity_url[] = validate_url($value);
                    break;
                case 'activity_openin':
                    $objeto->activity_openin[] = $value;
                    break;
            }
        }
    }

    $array = [];
    if ($valida) {
        if (isset($update)) {
            foreach ($update as $key => $value) {
                $DB->delete_records('agilesson_activity', ["id"=>$value->id]);
            }
            for ($i=0; $i < count($objeto->activity_name); $i++) {
                if(isset($objeto->activity_name[$i])){
                    $tmp_array = [
                        "id_agilesson"=>$id,
                        "activity_name"=>$objeto->activity_name[$i], 
                        "activity_url"=>$objeto->activity_url[$i], 
                        "activity_openin"=>$objeto->activity_openin[$i],
                    ];
                    array_push($array, $tmp_array);
                }
            }
        }
        else{
            for ($i=0; $i < count($objeto->activity_name); $i++) {
                if(isset($objeto->activity_name[$i])){
                    $tmp_array = [
                        "id_agilesson"=>$id,
                        "activity_name"=>$objeto->activity_name[$i], 
                        "activity_url"=>$objeto->activity_url[$i], 
                        "activity_openin"=>$objeto->activity_openin[$i],
                    ];
                    array_push($array, $tmp_array);
                }
            }
        }
    }
    else{
        if (isset($objeto->activity_name)) {
            for ($i=0; $i < count($objeto->activity_name); $i++) {
                $tmp_array = [
                    "id_agilesson"=>$id,
                    "activity_name"=>$objeto->activity_name[$i], 
                    "activity_url"=>$objeto->activity_url[$i], 
                    "activity_openin"=>$objeto->activity_openin[$i],
                ];
                array_push($array, $tmp_array);
            }
        }
    }
	return $array;
}

function validate_url($url){
    global $CFG;
    $new_url = "";

    $vimeo = strpos($url, 'vimeo');
    $youtube = strpos($url, 'youtube');
    $is_pdf = strpos($url, 'drive.google.com/file/d/');

    if($vimeo){
        $new_url = str_replace('vimeo.com/', 'player.vimeo.com/video/', $url);
    }

    if($youtube){
        $new_url = str_replace('watch?v=', 'embed/', $url);
    }

    if($is_pdf){
        $new_url = str_replace('/view', '/preview', $url);
    }

    if($new_url == ""){
        $new_url = $url;
    }

    return $new_url;
}

function insert_records_agilesson($table, $object){
    global $DB;

	if (!empty($object)) {
        $DB->insert_records($table, $object);
	}
}

function insert_record_agilesson($table, $object){
    global $DB;

	if (!empty($object)) {
        $DB->insert_record($table, $object);
	}
}

function update_records_agilesson($table, $object){
    global $DB;

    if(!empty($object)){
        foreach ($object as $key => $value) {
            if(isset($value->id)){
                $DB->update_record($table, $value);
            }
            else{
                $DB->insert_record($table, $value);
            }
        }
    }
}

function order_presentation_for_template($presentatios){
    $array_datos = array();
    foreach ($presentatios as $key => $value) {
        if ($key == "presentation_url") {
            $vimeo = strpos($value, 'vimeo');
            $youtube = strpos($value, 'youtube');
            if ($vimeo || $youtube) {
                $objeto = array("video" => ["presentation_url"=>$value]);
            }else{
                if($value!=""){
                    $objeto = array("imagen" => ["presentation_url"=>$value]);
                }else{
                    return $array_datos;
                }
            }
            array_push($array_datos, $objeto);
        }
    }
    return $array_datos;
}

function order_content_for_template($contents){
    $array_datos = array();
    foreach ($contents as $key => $value) {

     	$objeto = array("content" => $value);

        array_push($array_datos, $objeto);
    }
    return $array_datos;
}

function order_activity_for_template($activities){
    $array_datos = array();
    foreach ($activities as $key => $value) {

     	$objeto = array("activity" => $value);

        array_push($array_datos, $objeto);
    }
    return $array_datos;
}


function get_modules_info($modules,$courseid){
    global $USER,$CFG;
    $array_datos = array();
    $course = get_course($courseid);
    $completion = new completion_info($course);
    foreach($modules as $mod)
    {   
        $dat =get_coursemodule_from_id(null, $mod->module, $courseid, false, IGNORE_MISSING);
        
        if($dat){
            $state = $completion->get_data($dat);    
            
            $module_type = plugin_supports('mod', $dat->modname, FEATURE_MOD_ARCHETYPE, MOD_ARCHETYPE_OTHER);
        
            $class='studyContent__item--activity';
            if ($module_type == MOD_ARCHETYPE_RESOURCE) {           
                $class='studyContent__item--resource';
            } 
            $objeto = array("module"=>["module_id" => $mod->module,
                                    "content_name"=> $dat->name,
                                    "modname"=>$dat->modname,
                                    "content_openin"=>$mod->content_openin,
                                    "data-href"=>$CFG->wwwroot.'/mod/'.$dat->modname.'/view.php?id='.$mod->module,
                                    "data-scorm"=> ($dat->modname=='scorm'? true: false),
                                    "data-href-scorm"=> url_scorm_player($mod->module),
                                    "type_resource" => $class,
                                    "status_completion"=>$state->completionstate]);
        
            array_push($array_datos, $objeto);
        }
    }
    
    return $array_datos;
}

function url_scorm_player($module_id){
    $url_scorm = '';
 
     global $CFG,$DB;
     
    #-----------------------------------------------------------------------------
    # Arma la instruccion para consultar las categorias 
    # exceptuando la categoria 5 herramientas de comunicación general
    #-----------------------------------------------------------------------------
    $sql=" SELECT e.id as scoid, e.scorm 
    FROM mdl_scorm s
    JOIN mdl_scorm_scoes e ON (s.id=e.scorm) 
    JOIN mdl_course_modules c ON( c.instance=s.id )
    WHERE c.id=".$module_id."  
    AND e.scormtype in ('sco','asset')";
    
    $sql = str_replace('mdl_', $CFG->prefix, $sql);
    //Ejecuta la consulta en la BD
    $result= $DB->get_records_sql($sql);
    if(!empty($result)){
    foreach($result as $res){
    $scoid=$res->scoid;
    $a = $res->scorm;
    #-------------------------------------------------
    # Construye la URL del contenido del SCORM
    #-------------------------------------------------
    $url_scorm =$CFG->wwwroot."/mod/scorm/player.php?a=".$a."&scoid=".$scoid."&currentorg=&mode=normal&attempt=1&display=popup";
    
                //http://dominio.com/mod/scorm/player.php?a=5&currentorg=&scoid=10&sesskey=dDjcLSoqKo&display=popup&mode=normal
                //http://xplorabolivar.com/formamostalento/mod/scorm/player.php?a=73&currentorg=Mercadeo_N1_C5_ORG&scoid=223&sesskey=DXajXFQw8B&display=popup&mode=normal
    }//Fin Foreach
    }
    return $url_scorm;

 
}