<?php
defined('MOODLE_INTERNAL') || die();

function agilesson_supports($feature) {
	switch($feature) {
		case FEATURE_IDNUMBER:					return false;
        case FEATURE_GROUPS:					return false;
        case FEATURE_GROUPINGS:					return false;
        case FEATURE_GROUPMEMBERSONLY:			return false;
		case FEATURE_MOD_INTRO:               return true;
        case FEATURE_COMPLETION_TRACKS_VIEWS:	return false;
        case FEATURE_GRADE_HAS_GRADE:			return false;
        case FEATURE_GRADE_OUTCOMES:			return false;
		case FEATURE_MOD_ARCHETYPE:				return MOD_ARCHETYPE_RESOURCE;
		case FEATURE_BACKUP_MOODLE2:			return true;
		case FEATURE_NO_VIEW_LINK:            return true;
		
        default: 								return null;
    }
}

function agilesson_add_instance($agilesson){
	global $CFG, $DB;
	
	require_once($CFG->dirroot.'/mod/agilesson/locallib.php');

	$sia = new sia_agilesson();
	$path = $sia->get_path_sia($agilesson->modulename);
	
	
	
	$agilesson_data = new stdClass();
	$presentation_data = new stdClass();
	$contents_data = new stdClass();
	$activities_data = new stdClass();
	$modules_data = new stdClass();

	if($path->status == 1){
        $agilesson_data = order_agilesson_data($agilesson);
		$id = $DB->insert_record('agilesson', $agilesson_data);
        if($id){
            $presentation_data = order_presentation_data($agilesson, $id);
			$contents_data = order_content_data($agilesson, $id);
			$activities_data = order_activity_data($agilesson, $id);
			$modules_data = order_modules_data($agilesson, $id);

			insert_record_agilesson('agilesson_presentation', $presentation_data);
			insert_records_agilesson('agilesson_content', $contents_data);
			insert_records_agilesson('agilesson_activity', $activities_data);
			insert_records_agilesson('agilesson_modules', $modules_data);

            return $id;
        }
        else{
            return false;
        }
    }
    else{
		$agilesson_data = order_agilesson_data($agilesson);
		$agilesson_data['name'] = "Error - ".$path->msn;
		//$agilesson_data['course'] = $agilesson->course;
		
		$id = $DB->insert_record('agilesson', $agilesson_data);
		
		$presentation_data = order_presentation_data($agilesson, $id);
		//$presentation_data['presentation_url'] = "";		
		insert_record_agilesson('agilesson_presentation', $presentation_data);
		
        return $id;
    }
	
}


function agilesson_update_instance($agilesson){
	global $CFG, $DB;
	
	require_once($CFG->dirroot.'/mod/agilesson/locallib.php');
	
	$agilesson_data = new stdClass();
	$presentation_data = new stdClass();
	$contents_data = new stdClass();
	$activities_data = new stdClass();
	$modules_data = new stdClass();
	
	$id = $agilesson->instance;
	$agilesson_data = order_agilesson_data($agilesson, $id);
	$DB->update_record('agilesson', $agilesson_data);

	$presentations = $DB->get_record('agilesson_presentation', ["id_agilesson"=>$id], 'id', 'id');
	$contents = $DB->get_records('agilesson_content', ["id_agilesson"=>$id], 'id', 'id');
	$activities = $DB->get_records('agilesson_activity', ["id_agilesson"=>$id], 'id', 'id');
	
	$presentation_data = order_presentation_data($agilesson, $id, $presentations);
	$DB->update_record('agilesson_presentation', $presentation_data);

	
	$contents_data = order_content_data($agilesson, $id, $contents, true);
	$activities_data = order_activity_data($agilesson, $id, $activities, true);

	$modules_data = order_modules_data($agilesson, $id, true);
	insert_records_agilesson('agilesson_modules', $modules_data);
	
	update_records_agilesson('agilesson_content', $contents_data);
	update_records_agilesson('agilesson_activity', $activities_data);



	return true;
}


function agilesson_delete_instance($id){
	global $DB;

    if (!$agilesson = $DB->get_record('agilesson', array('id'=>$id))) {
        return false;
    }

    // Nota: todos los archivos de contexto son eliminados automaticamente.

    $DB->delete_records('agilesson', array('id'=>$agilesson->id));
    $DB->delete_records('agilesson_presentation', array('id_agilesson'=>$agilesson->id));
    $DB->delete_records('agilesson_content', array('id_agilesson'=>$agilesson->id));
	$DB->delete_records('agilesson_activity', array('id_agilesson'=>$agilesson->id));
	$DB->delete_records('agilesson_modules', array('id_agilesson'=>$agilesson->id));

    return true;
}

/**
 * Given a course_module object, this function returns any
 * "extra" information that may be needed when printing
 * this activity in a course listing.
 * See get_array_of_activities() in course/lib.php
 *
 * @global object
 * @param object $coursemodule
 * @return cached_cm_info|null
 */

function agilesson_get_coursemodule_info($coursemodule){
	global $PAGE;
	if( $coursemodule->deletioninprogress==0){
		$output = $PAGE->get_renderer('mod_agilesson');
		$view = new \mod_agilesson\output\agileview($coursemodule->instance);
		$info = new cached_cm_info();
		$info->content = $output->render($view);
		return $info;
	}else{
		$info = new cached_cm_info();
		return $info;
	}
}