<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package     mod_agilesson
 * @copyright   2019 Jose Gomez <info@escueladidactica.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
namespace mod_agilesson\output;
defined('MOODLE_INTERNAL') || die();

use renderable;
use renderer_base;
use templatable;

require_once($CFG->dirroot . "/mod/agilesson/locallib.php"); //Libreria de funciones usadas en export_for_template

/**
 * Class containing data for my overview block.
 *
 * @copyright  2017 Simey Lameze <simey@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class agileview implements renderable, templatable {

    /**
     * @var string The tab to display.
     */
    public $instanceid;

    /**
     * Constructor.
     *
     * @param string $courseid The tab to display.
     */
    public function __construct($instanceid) {
        $this->instance = $instanceid;
    }

    /**
     * Export this data so it can be used as the context for a mustache template.
     *
     * @param \renderer_base $output
     * @return stdClass
     */
    public function export_for_template(renderer_base $output) {
        global $DB, $CFG;
        $status_activity = false;
        $status_content = false;
        $status_module = false;
        $status_title = false;
        $sequentially = false;

        $agilesson = $DB->get_record('agilesson', array('id'=> $this->instance), '*', MUST_EXIST);
        $presentation = $DB->get_record('agilesson_presentation', array('id_agilesson'=> $this->instance), '*', MUST_EXIST);
        $contents = $DB->get_records('agilesson_content', array('id_agilesson'=> $this->instance));
        $activities = $DB->get_records('agilesson_activity', array('id_agilesson'=> $this->instance));        
        $modules = $DB->get_records('agilesson_modules', array('id_agilesson'=> $this->instance),$sort='id');

    


        $presentation = order_presentation_for_template($presentation);
        $contents = order_content_for_template($contents);
        $activities = order_activity_for_template($activities);
        $modules = get_modules_info($modules,$agilesson->course);

        if ($agilesson->titlestatus == 1) {
            $status_title = true;
        }

        $show_description=false;
        if ($agilesson->description!="") {
            $show_description = true;
        }

        if($agilesson->sequentially == 1){
            $sequentially = true;
        }

        if (!empty($activities)) {
            $status_activity = true;
        }

        if (!empty($contents)) {
            $status_content = true;
        }

        if (!empty($modules)) {
            $status_module = true;
        }
        $data = [
            'instanceid' => $agilesson->id,
            'agilesson_name' => $agilesson->name,
            'agilesson_titlestatus' => $status_title,
            'presentation' => $presentation,
            'show_description' => $show_description,
            'description' => $agilesson->description,
            'agilesson_sequentially' => $sequentially,
            'status_content' => $status_content,
            'contents' => $contents,
            'modules'  => $modules,
            'status_activity' => $status_activity,
            'status_module' => $status_module,
            'activities' => $activities,
            'wwwroot' => $CFG->wwwroot,
        ];
      
        return $data;
    }
}
