<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package     mod_agilesson
 * @copyright   2019 Jose Gomez <info@escueladidactica.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

class restore_agilesson_activity_structure_step extends restore_activity_structure_step {


    /**
     * Define the structure of the restore workflow.
     *
     * @return restore_path_element $structure
     */
    protected function define_structure() {

        $paths = array();

        // Define each element separated.
        $paths[] = new restore_path_element('agilesson', '/activity/agilesson');
        
        $paths[]= new restore_path_element('agilesson_presentation', '/activity/agilesson/presentations/presentation');

        
        $paths[]= new restore_path_element('agilesson_content', '/activity/agilesson/contents/content');

        $paths[]= new restore_path_element('agilesson_activity', '/activity/agilesson/actitivies/activity');

        $paths[]= new restore_path_element('agilesson_module', '/activity/agilesson/modules/module');
       

       

        return $this->prepare_activity_structure($paths);
    }

    /**
     * Process an assign restore.
     *
     * @param object $data The data in object form
     * @return void
     */
    protected function process_agilesson($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;
        $data->course = $this->get_courseid();
        $data->timecreated = $this->apply_date_offset($data->timecreated);
        $data->timemodified = $this->apply_date_offset($data->timemodified);

        if (!isset($data->name)) {
            $data->name = "";
        }
        if (!isset($data->description)) {
            $data->description = "";
        }
        if (!isset($data->status)) {
            $data->status = 0;
        }

        $newitemid = $DB->insert_record('agilesson', $data);

        $this->apply_activity_instance($newitemid);
    }

    /**
     * Process a presentation restore
     * @param object $data The data in object form
     * @return void
     */
    protected function process_agilesson_presentation($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;

        $data->id_agilesson = $this->get_new_parentid('agilesson');

        if (!isset($data->presentation_url)) {
            $data->presentation_url = "";
        }

        $newitemid = $DB->insert_record('agilesson_presentation', $data);
        $this->set_mapping('agilesson_presentation', $oldid, $newitemid);
    }

    /**
     * Process a user_flags restore
     * @param object $data The data in object form
     * @return void
     */
    protected function process_agilesson_content($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;

        $data->id_agilesson = $this->get_new_parentid('agilesson');

        if (!isset($data->content_name)) {
            $data->content_name = "";
        }
        if (!isset($data->content_url)) {
            $data->content_url = "";
        }
        if (!isset($data->content_openin)) {
            $data->content_openin = 0;
        }

        $newitemid = $DB->insert_record('agilesson_content', $data);
  
    }

    /**
     * Process a grade restore
     * @param object $data The data in object form
     * @return void
     */
    protected function process_agilesson_activity($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;

        $data->id_agilesson = $this->get_new_parentid('agilesson');

        if (!isset($data->activity_name)) {
            $data->activity_name = "";
        }
        if (!isset($data->activity_url)) {
            $data->activity_url = "";
        }
        if (!isset($data->activity_openin)) {
            $data->activity_openin = 0;
        }


        $newitemid = $DB->insert_record('agilesson_activity', $data);
   
    }
    /**
     * Process a grade restore
     * @param object $data The data in object form
     * @return void
     */
    protected function process_agilesson_module($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;

        $data->id_agilesson = $this->get_new_parentid('agilesson');
       
        if (!isset($data->module)) {
            $data->module = "";
        }
        if (!isset($data->content_openin)) {
            $data->content_openin = 0;
        }



        $newitemid = $DB->insert_record('agilesson_modules', $data);
        
    }
}
