<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package     mod_agilesson
 * @copyright   2019 Jose Gomez <info@escueladidactica.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . '/mod/agilesson/backup/moodle2/restore_agilesson_stepslib.php');

class restore_agilesson_activity_task extends restore_activity_task {

    /**
     * Define (add) particular settings this activity can have.
     */
    protected function define_my_settings() {
        // No particular settings for this activity.
    }

    /**
     * Define (add) particular steps this activity can have.
     */
    protected function define_my_steps() {
        // Assignment only has one structure step.
        $this->add_step(new restore_agilesson_activity_structure_step('agilesson_structure', 'agilesson.xml'));
    }

    /**
     * Define the contents in the activity that must be
     * processed by the link decoder
     */
    static public function define_decode_contents() {
        $contents = array();

        //$contents[] = new restore_decode_content('agilesson', array('intro'), 'agilesson');
        

        return $contents;
    }


    /**
     * Define the decoding rules for links belonging
     * to the activity to be executed by the link decoder.
     *
     * @return array of restore_decode_rule
     */
    static public function define_decode_rules() {
        $rules = array();

        /* $rules[] = new restore_decode_rule('AGILESSONVIEWBYID',
                                           '/mod/agilesson/view.php?id=$1',
                                           'course_module');
        $rules[] = new restore_decode_rule('AGILESSONINDEX',
                                           '/mod/agilesson/index.php?id=$1',
                                           'course'); */

        return $rules;

    }

    /**
     * Define the restore log rules that will be applied
     * by the {@link restore_logs_processor} when restoring
     * agilesson logs. It must return one array
     * of {@link restore_log_rule} objects.
     *
     * @return array of restore_log_rule
     */
    static public function define_restore_log_rules() {
        $rules = array();

      /*   $rules[] = new restore_log_rule('agilesson', 'add', 'view.php?id={course_module}', '{agilesson}');
        $rules[] = new restore_log_rule('agilesson', 'update', 'view.php?id={course_module}', '{agilesson}');
        $rules[] = new restore_log_rule('agilesson', 'view', 'view.php?id={course_module}', '{agilesson}'); */

        return $rules;
    }

    /**
     * Define the restore log rules that will be applied
     * by the {@link restore_logs_processor} when restoring
     * course logs. It must return one array
     * of {@link restore_log_rule} objects
     *
     * Note this rules are applied when restoring course logs
     * by the restore final task, but are defined here at
     * activity level. All them are rules not linked to any module instance (cmid = 0)
     *
     * @return array
     */
    static public function define_restore_log_rules_for_course() {
        $rules = array();

        return $rules;
    }
    
    public function after_restore () { 
        global $DB;

        $agilessons = $DB->get_records('agilesson_modules', array('id_agilesson' => $this->get_activityid()), 'id, id_agilesson, module');

        if (!empty($agilessons)) {
            foreach ($agilessons as  $agilesson) {              
                if ($newitem = restore_dbops::get_backup_ids_record($this->get_restoreid(), 'course_module' ,$agilesson->module)) {
                    $agilesson->module = $newitem->newitemid;
                    $DB->update_record('agilesson_modules', $agilesson);
                }
            }

        }
      
        
    }

}
