<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package     mod_agilesson
 * @copyright   2019 Jose Gomez <info@escueladidactica.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

class backup_agilesson_activity_structure_step extends backup_activity_structure_step {

    /**
     * Define the structure for the agilesson activity
     * @return void
     */
    protected function define_structure() {

        // To know if we are including userinfo
        $userinfo = $this->get_setting_value('userinfo');

        // Define each element separated.
        $agilesson = new backup_nested_element('agilesson', array('id'),
                                            array('course',
                                                  'name',
                                                  'description',
                                                  'status',
                                                  'timecreated',
                                                  'timemodified'));


        $presentations = new backup_nested_element('presentations');
        $presentation = new backup_nested_element('presentation', array('id'),
                                                array('presentation_url'));

        $contents = new backup_nested_element('contents');
        $content = new backup_nested_element('content', array('id'),
                                           array('content_name',
                                                 'content_url',
                                                 'content_openin'));

        $activities = new backup_nested_element('activities');
        $activity = new backup_nested_element('agilesson_activity', array('id'),
                                                   array('activity_name',
                                                         'activity_url',
                                                         'activity_openin'));
        $modules = new backup_nested_element('modules');
        $module = new backup_nested_element('module', array('id'),
                                                array('module',
                                                        'content_openin'
                                                        ));
        // Build the tree.
        $agilesson->add_child($presentations);
        $presentations->add_child($presentation);
        $agilesson->add_child($contents);
        $contents->add_child($content);
        $agilesson->add_child($activities);
        $activities->add_child($activity);
        $agilesson->add_child($modules);
        $modules->add_child($module);
        // Define sources.
        $agilesson->set_source_table('agilesson', array('id' => backup::VAR_ACTIVITYID));
        
        //$presentation->set_source_sql('SELECT * FROM {agilesson_presentation} WHERE id_agilesson = ?', array(backup::VAR_PARENTID));
        //$content->set_source_sql('SELECT * FROM {agilesson_content} WHERE id_agilesson = ?', array(backup::VAR_PARENTID));
        //$activity->set_source_sql('SELECT * FROM {agilesson_activity} WHERE id_agilesson = ?', array(backup::VAR_PARENTID));
        
        //if($userinfo){
            $presentation->set_source_table('agilesson_presentation', array('id_agilesson' => backup::VAR_PARENTID));
    
            $content->set_source_table('agilesson_content', array('id_agilesson' => backup::VAR_PARENTID));
    
            $activity->set_source_table('agilesson_activity', array('id_agilesson' => backup::VAR_PARENTID));

            $module->set_source_table('agilesson_modules', array('id_agilesson' => backup::VAR_PARENTID));
        //}


        $agilesson->annotate_files('mod_agilesson', 'course', null);

        // Define id annotations.
        //$agilesson->annotate_ids('course', 'course');

        // Return the root element (choice), wrapped into standard activity structure.
        return $this->prepare_activity_structure($agilesson);
    }
}
