<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package     mod_agilesson
 * @copyright   2019 Jose Gomez <info@escueladidactica.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();
require_once($CFG->dirroot . '/mod/agilesson/backup/moodle2/backup_agilesson_stepslib.php');
require_once($CFG->dirroot . '/mod/agilesson/backup/moodle2/backup_agilesson_settingslib.php');

class backup_agilesson_activity_task extends backup_activity_task {

    /**
     * Define (add) particular settings this activity can have
     */
    protected function define_my_settings() {
        // No particular settings for this activity.
    }

    /**
     * Define (add) particular steps this activity can have
     */
    protected function define_my_steps() {
        $this->add_step(new backup_agilesson_activity_structure_step('agilesson_structure', 'agilesson.xml'));
    }

    /**
     * Code the transformations to perform in the activity in
     * order to get transportable (encoded) links
     * @param string $content
     * @return string
     */
    static public function encode_content_links($content) {
        /*global $CFG;

        $base = preg_quote($CFG->wwwroot, "/");

        $search="/(".$base."\/mod\/agilesson\/index.php\?id\=)([0-9]+)/";
        $content= preg_replace($search, '$@AGILESSONINDEX*$2@$', $content);

        $search="/(".$base."\/mod\/agilesson\/view.php\?id\=)([0-9]+)/";
        $content= preg_replace($search, '$@AGILESSONVIEWBYID*$2@$', $content);*/

        return $content;
    }

}

